-- change directory to program location
parse source  . . pgm
call directory filespec('L', pgm) 

-- create a new document and add a blank page
doc=.bsf~new("org.apache.pdfbox.pdmodel.PDDocument")
page=.bsf~new("org.apache.pdfbox.pdmodel.PDPage")
doc~addPage(page)

-- create a content stream
contclass = "org.apache.pdfbox.pdmodel.PDPageContentStream"
cont=.bsf~new(contclass,doc,page)

-- define font type
fontclass = "org.apache.pdfbox.pdmodel.font.Standard14Fonts"
fname = BSF.loadClass(fontclass)~FontName~HELVETICA
font=.bsf~new("org.apache.pdfbox.pdmodel.font.PDType1Font",fname)

-- use the content stream to insert content
cont~beginText
cont~setFont(font, 15)
cont~setLeading(25f)
cont~newLineAtOffset( 100, 700 )
cont~showText("This is a normal line")
cont~newLine

-- use a new font type
fname = BSF.loadClass(fontclass)~FontName~HELVETICA_BOLD
font=.bsf~new("org.apache.pdfbox.pdmodel.font.PDType1Font",fname)
cont~setFont(font, 15)
cont~showText("This is a bold line")
cont~newLine

-- use a new font type
fname = BSF.loadClass(fontclass)~FontName~HELVETICA_OBLIQUE
font=.bsf~new("org.apache.pdfbox.pdmodel.font.PDType1Font",fname)
cont~setFont(font, 15)
cont~showText("This is an italic line")
cont~newLine

-- use a new font type
fname = BSF.loadClass(fontclass)~FontName~COURIER
font=.bsf~new("org.apache.pdfbox.pdmodel.font.PDType1Font",fname)
cont~setFont(font, 15)
cont~showText("This is a line in COURIER")
cont~newLine

-- use a new font type
fname = BSF.loadClass(fontclass)~FontName~TIMES_ROMAN
font=.bsf~new("org.apache.pdfbox.pdmodel.font.PDType1Font",fname)
cont~setFont(font, 15)
cont~showText("This is a line in TIMES_ROMAN")
cont~setLeading(45f)
cont~newLine

-- use a bigger font size
cont~setFont(font, 25)
cont~showText("This is a bigger line")
cont~newLine

-- use a new font color
col=BSF.loadClass("java.awt.Color")~red
cont~setNonStrokingColor(col)
cont~showText("This is a red line")
cont~newLine

-- use a new font color
col=BSF.loadClass("java.awt.Color")~blue
cont~setNonStrokingColor(col)
cont~showText("This is a blue line")
cont~endText
cont~close

-- save and close the document file
doc~save("03-different styles.pdf")
doc~close

-- get java support
::requires "BSF.CLS"